<?php

namespace App\Policies;

use App\Helpers\Authorize;
use App\Models\Supplier;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class SupplierPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view suppliers.
     *
     * @param  \App\Models\User  $user
     * @return mixed
     */
    public function index(User $user)
    {
        return (new Authorize($user, 'view_supplier'))->check();
    }

    /**
     * Determine whether the user can view the Supplier.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Supplier  $supplier
     * @return mixed
     */
    public function view(User $user, Supplier $supplier)
    {
        return (new Authorize($user, 'view_supplier', $supplier))->check();
    }

    /**
     * Determine whether the user can create Suppliers.
     *
     * @param  \App\Models\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        return (new Authorize($user, 'add_supplier'))->check();
    }

    /**
     * Determine whether the user can update the Supplier.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Supplier  $supplier
     * @return mixed
     */
    public function update(User $user, Supplier $supplier)
    {
        return (new Authorize($user, 'edit_supplier', $supplier))->check();
    }

    /**
     * Determine whether the user can delete the Supplier.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Supplier  $supplier
     * @return mixed
     */
    public function delete(User $user, Supplier $supplier)
    {
        return (new Authorize($user, 'delete_supplier', $supplier))->check();
    }

    /**
     * Determine whether the user can delete the Product.
     *
     * @param  \App\Models\User  $user
     * @return mixed
     */
    public function massDelete(User $user)
    {
        return (new Authorize($user, 'delete_supplier'))->check();
    }
}
