<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Gmail;

class ListLabelsResponse extends \Google\Collection
{
  protected $collection_key = 'labels';
  /**
   * @var Label[]
   */
  public $labels;
  protected $labelsType = Label::class;
  protected $labelsDataType = 'array';
  /**
   * @var int
   */
  public $productId;

  /**
   * @param Label[]
   */
  public function setLabels($labels)
  {
    $this->labels = $labels;
  }
  /**
   * @return Label[]
   */
  public function getLabels()
  {
    return $this->labels;
  }
  /**
   * @param int
   */
  public function setProductId($productId)
  {
    $this->productId = $productId;
  }
  /**
   * @return int
   */
  public function getProductId()
  {
    return $this->productId;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ListLabelsResponse::class, 'Google_Service_Gmail_ListLabelsResponse');
