<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ServiceConsumerManagement;

class Type extends \Google\Collection
{
  protected $collection_key = 'options';
  /**
   * @var string
   */
  public $edition;
  /**
   * @var Field[]
   */
  public $fields;
  protected $fieldsType = Field::class;
  protected $fieldsDataType = 'array';
  /**
   * @var string
   */
  public $name;
  /**
   * @var string[]
   */
  public $oneofs;
  /**
   * @var Option[]
   */
  public $options;
  protected $optionsType = Option::class;
  protected $optionsDataType = 'array';
  /**
   * @var SourceContext
   */
  public $sourceContext;
  protected $sourceContextType = SourceContext::class;
  protected $sourceContextDataType = '';
  /**
   * @var string
   */
  public $syntax;

  /**
   * @param string
   */
  public function setEdition($edition)
  {
    $this->edition = $edition;
  }
  /**
   * @return string
   */
  public function getEdition()
  {
    return $this->edition;
  }
  /**
   * @param Field[]
   */
  public function setFields($fields)
  {
    $this->fields = $fields;
  }
  /**
   * @return Field[]
   */
  public function getFields()
  {
    return $this->fields;
  }
  /**
   * @param string
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * @param string[]
   */
  public function setOneofs($oneofs)
  {
    $this->oneofs = $oneofs;
  }
  /**
   * @return string[]
   */
  public function getOneofs()
  {
    return $this->oneofs;
  }
  /**
   * @param Option[]
   */
  public function setOptions($options)
  {
    $this->options = $options;
  }
  /**
   * @return Option[]
   */
  public function getOptions()
  {
    return $this->options;
  }
  /**
   * @param SourceContext
   */
  public function setSourceContext(SourceContext $sourceContext)
  {
    $this->sourceContext = $sourceContext;
  }
  /**
   * @return SourceContext
   */
  public function getSourceContext()
  {
    return $this->sourceContext;
  }
  /**
   * @param string
   */
  public function setSyntax($syntax)
  {
    $this->syntax = $syntax;
  }
  /**
   * @return string
   */
  public function getSyntax()
  {
    return $this->syntax;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Type::class, 'Google_Service_ServiceConsumerManagement_Type');
